<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class TemplatesMultiListing extends STMMultiListing {

	public function __construct() {
		parent::__construct();

		add_filter( 'single_template', array( $this, 'singlePostTypeTemplate' ), 15 );
		add_filter( 'archive_template', array( $this, 'archivePostTypeTemplate' ), 15 );
		add_action( 'stm_account_custom_page', array( $this, 'addPostTypeCustomListingPage' ) );
	}

	public function singlePostTypeTemplate( $single ) {
		global $post;

		if ( is_array( $this->listings ) && count( $this->listings ) ) {
			foreach ( $this->listings as $listing ) {
				$slug = isset( $listing['slug'] ) ? $listing['slug'] : '';
				$name = isset( $listing['name'] ) ? $listing['name'] : '';

				if ( empty( $slug ) || empty( $name ) ) {
					return $single;
				}

				if ( isset( $post->post_type ) && $post->post_type === $slug ) {
					if ( function_exists( 'stm_listings_locate_template' ) ) {
						$located = stm_listings_locate_template( 'single.php' );
						if ( $located ) {
							return $located;
						}
					}

					if ( file_exists( get_stylesheet_directory() . "/single-{$slug}.php" ) ) {
						return get_stylesheet_directory() . "/single-{$slug}.php";
					}
					if ( file_exists( get_template_directory() . "/single-{$slug}.php" ) ) {
						return get_template_directory() . "/single-{$slug}.php";
					}
					if ( file_exists( get_stylesheet_directory() . '/single-listings.php' ) ) {
						return get_stylesheet_directory() . '/single-listings.php';
					}
					if ( file_exists( get_template_directory() . '/single-listings.php' ) ) {
						return get_template_directory() . '/single-listings.php';
					}
					return get_template_directory() . '/single.php';
				}
			}
		}

		return $single;
	}

	public function archivePostTypeTemplate( $archive ) {
		global $post;

		if ( is_array( $this->listings ) && count( $this->listings ) ) {
			foreach ( $this->listings as $listing ) {
				$slug = isset( $listing['slug'] ) ? $listing['slug'] : '';
				$name = isset( $listing['name'] ) ? $listing['name'] : '';

				if ( empty( $slug ) || empty( $name ) ) {
					return $archive;
				}

				if ( isset( $post->post_type ) && $post->post_type === $slug ) {
					if ( function_exists( 'stm_listings_locate_template' ) ) {
						$located = stm_listings_locate_template( 'archive.php' );
						if ( $located ) {
							return $located;
						}
					}

					if ( file_exists( get_stylesheet_directory() . "/archive-{$slug}.php" ) ) {
						return get_stylesheet_directory() . "/archive-{$slug}.php";
					}
					if ( file_exists( get_template_directory() . "/archive-{$slug}.php" ) ) {
						return get_template_directory() . "/archive-{$slug}.php";
					}
					if ( file_exists( get_stylesheet_directory() . '/archive-listings.php' ) ) {
						return get_stylesheet_directory() . '/archive-listings.php';
					}
					if ( file_exists( get_template_directory() . '/archive-listings.php' ) ) {
						return get_template_directory() . '/archive-listings.php';
					}
					return get_template_directory() . '/index.php';
				}
			}
		}

		return $archive;
	}

	public function addPostTypeCustomListingPage( $current ) {
		if ( is_array( $this->listings ) && count( $this->listings ) ) {
			foreach ( $this->listings as $listing ) {
				$slug = isset( $listing['slug'] ) ? $listing['slug'] : '';
				if ( $current === $slug ) {
					$post_type = $current; // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
					if ( file_exists( get_stylesheet_directory() . "/multilisting/user/private/listing-list-{$slug}.php" ) ) {
						include_once get_stylesheet_directory() . "/multilisting/user/private/listing-list-{$slug}.php";
					} elseif ( file_exists( get_template_directory() . "/multilisting/user/private/listing-list-{$slug}.php" ) ) {
						include_once get_template_directory() . "/multilisting/user/private/listing-list-{$slug}.php";
					} else {
						include_once MULTILISTING_PATH . '/templates/listing-list-edit.php';
					}
				}
			}
		}
		return true;
	}
}

new TemplatesMultiListing();
