class MotorsListingsMap extends elementorModules.frontend.handlers.Base {
	
	getDefaultSettings() {
		return {
			selectors: {
				stm_map: '.stm_gmap',
			},
		};
		
	}

	getDefaultElements() {
		const selectors = this.getSettings('selectors');
		return {
			$stm_map: this.$element.find(selectors.stm_map),
		};
	}

	mapInit() {
		const mapElement = this.elements.$stm_map[0];
		const latitudes = parseFloat(mapElement.getAttribute('data-lat'));
		const longitudes = parseFloat(mapElement.getAttribute('data-lng'));
		const zoom = parseInt(mapElement.getAttribute('data-zoom'));
		const address = mapElement.getAttribute('data-address');
		const radius = parseInt(mapElement.getAttribute('data-radius'));
		const scrollwheel = mapElement.getAttribute('data-scrollwheel');
		const pin_url = mapElement.getAttribute('data-pin-url');
		const cluster_pin_url = mapElement.getAttribute('data-cluster-pin-url');
		const center = new google.maps.LatLng(latitudes, longitudes);
		const infoWindow = new google.maps.InfoWindow();

		const bounds = new google.maps.LatLngBounds();
		const map = new google.maps.Map(mapElement, {
			zoom: zoom,
			center: center,
			fullscreenControl: true,
			scrollwheel: scrollwheel,
			mapTypeId: 'roadmap',
			minZoom: 2,
			maxZoom: 20,
		});

		let markers = [];

		mapElement.classList.add('stm-loading');

		let data = 'ca_location=' + address + '&stm_lat=' + latitudes + '&stm_lng=' + longitudes + '&max_search_radius=' + radius;

		jQuery.ajax({
			url: ajaxurl,
			type: "GET",
			data: 'action=stm_ajax_get_cars_for_inventory_map&security=' + stm_security_nonce + '&' + data,
			dataType: "json",
			success: function (msg) {
				mapElement.classList.remove('stm-loading');

				let locations = msg['markers'];
				let carData = msg['carsData'];
				let mapLocationCar = msg['mapLocationCar'];

				var ordX = -24;
				var ordY = -30;
				var ordY1 = -355;
				var ordY2 = -515;

				for (var i = 0; i < locations.length; i++) {

					var latLng = new google.maps.LatLng(locations[i]["lat"], locations[i]["lng"]);

					if (i == 0) {
						let center = new google.maps.LatLng(locations[i]["lat"], locations[i]["lng"]);
						map.setCenter(center);
					}

					var marker = new google.maps.Marker({
						position: latLng,
						icon: pin_url,
						map: map
					});

					var infowindow = new google.maps.InfoWindow({
						maxWidth: 315,
						disableAutoPan: true
					});

					markers.push(marker);
					google.maps.event.addListener(marker, 'click', (function (marker, i) {
						return function () {
							var iwlatLng = new google.maps.LatLng(locations[i]["lat"], locations[i]["lng"]);

							if (mapLocationCar[locations[i]["lat"]].length === 1) {

								infowindow.setContent('<div class="stm_map_info_window_group_wrap"><a class="stm_iw_link" href="' + carData[i]["link"] + '" width="300" height="147"> <div class="stm_map_info_window_wrap">' +
									'<div class="stm_iw_condition">' + carData[i]["condition"] + ' ' + carData[i]["year"] + '</div>' +
									'<div class="stm_iw_title">' + carData[i]["title"] + '</div>' +
									'<div class="stm_iw_car_data_wrap">' +
									'<div class="stm_iw_img_wrap">' +
									carData[i]["image"] +
									'</div>' +
									'<div class="stm_iw_car_info">' +
									'<span class="stm_iw_car_opt stm_car_mlg"><i class="' + carData[i]["mileage_font"] + '"></i>' + carData[i]["mileage"] + '</span>' +
									'<span class="stm_iw_car_opt stm_car_engn"><i class="' + carData[i]["engine_font"] + '"></i>' + carData[i]["engine"] + '</span>' +
									'<span class="stm_iw_car_opt stm_car_trnsmsn"><i class="' + carData[i]["transmission_font"] + '"></i>' + carData[i]["transmission"] + '</span>' +
									'</div>' +
									'</div>' +
									'<div class="stm_iw_car_price"><span class="stm_iw_price_trap"></span>' + carData[i]["price"] + '</div>' +
									'</div></a></div>');

								infowindow.setOptions({pixelOffset: new google.maps.Size(ordX, ordY)});
								infowindow.open(map, marker);

							} else {
								var iwlatLng = new google.maps.LatLng(locations[i]["lat"], locations[i]["lng"]);
								var groupClass = (mapLocationCar[locations[i]["lat"]].length <= 3) ? "stm_if_group_" + mapLocationCar[locations[i]["lat"]].length + " stm_if_group_no_scroll" : "stm_if_group_scroll"

								var infoWindowHtml = '<div class="stm_map_info_window_group_wrap ' + groupClass + '"><div class="stm_if_scroll">';

								for (var w = 0; w < mapLocationCar[locations[i]["lat"]].length; w++) {
									var carPos = mapLocationCar[locations[i]["lat"]][w];
									infoWindowHtml += '<a class="stm_iw_link" href="' + carData[carPos]["link"] + '"> <div class="stm_map_info_window_wrap">' +
										'<div class="stm_iw_condition">' + carData[carPos]["condition"] + ' ' + carData[carPos]["year"] + '</div>' +
										'<div class="stm_iw_title">' + carData[carPos]["title"] + '</div>' +
										'<div class="stm_iw_car_data_wrap">' +
										'<div class="stm_iw_img_wrap">' +
										carData[carPos]["image"] +
										'</div>' +
										'<div class="stm_iw_car_info">' +
										'<span class="stm_iw_car_opt stm_car_mlg"><i class="' + carData[carPos]["mileage_font"] + '"></i>' + carData[carPos]["mileage"] + '</span>' +
										'<span class="stm_iw_car_opt stm_car_engn"><i class="' + carData[carPos]["engine_font"] + '"></i>' + carData[carPos]["engine"] + '</span>' +
										'<span class="stm_iw_car_opt stm_car_trnsmsn"><i class="' + carData[carPos]["transmission_font"] + '"></i>' + carData[carPos]["transmission"] + '</span>' +
										'</div>' +
										'</div>' +
										'<div class="stm_iw_car_price"><span class="stm_iw_price_trap"></span>' + carData[carPos]["price"] + '</div>' +
										'</div></a>';
								}

								infoWindowHtml += '</div></div>';

								infowindow.setContent(infoWindowHtml);

								if (mapLocationCar[locations[i]["lat"]].length == 2) {
									infowindow.setOptions({pixelOffset: new google.maps.Size(ordX, ordY1)})
								} else {
									infowindow.setOptions({pixelOffset: new google.maps.Size(ordX, ordY2)})
								}

								infowindow.open(map, marker);
							}
						}

					})(marker, i));
				}

				let algorithm = new markerClusterer.GridAlgorithm({
					maxZoom: 9,
					averageCenter: true,
				});

				let renderer = {
					render({ count, position }) {
						return new google.maps.Marker({
							label: {
								text: String(count),
								color: 'white',
								fontSize: '20px',
								fontWeight: 'bold',
							},
							position,
							icon: {
								url: cluster_pin_url,
								scaledSize: new google.maps.Size(60, 60),
							},
							zIndex: Number(google.maps.Marker.MAX_ZINDEX) + count,
						});
					}
				}

				let markerCluster = new markerClusterer.MarkerClusterer({
					map: map,
					markers: markers,
					algorithm: algorithm,
					renderer: renderer,
				});

				google.maps.event.addListener(map, 'click', function () {
					if (infowindow) {
						infowindow.close();
					}
				});
			}
		});

		return map;
	}

	mapSetup() {
		const mapElement = this.elements.$stm_map[0];
		if ( typeof mapElement !== 'undefined') {
			const latitudes = parseFloat(mapElement.getAttribute('data-lat'));
			const longitudes = parseFloat(mapElement.getAttribute('data-lng'));

			const center = new google.maps.LatLng(latitudes, longitudes);

			let map = this.mapInit();
			jQuery(window).on('resize', function () {
				map.setCenter(center);
			});
		}
	}

	onInit() {
		super.onInit()

		if ( typeof google.maps.LatLng !== 'undefined') {
			this.mapSetup();
		} else {
			document.body.addEventListener('stm_gmap_api_loaded', () => { this.mapSetup() }, false);
		}
	}

}

jQuery(window).on('elementor/frontend/init', () => {
	const addHandler = ($element) => {
		elementorFrontend.elementsHandler.addHandler(MotorsListingsMap, {
			$element,
		});
	};

	elementorFrontend.hooks.addAction('frontend/element_ready/motors-listings-map.default', addHandler);
});
