<?php

namespace Motors_E_W\Pro\Widgets\SingleListing;

use Motors_E_W\MotorsApp;
use STM_E_W\Helpers\Helper;
use STM_E_W\Widgets\Controls\ContentControls\HeadingControl;
use STM_E_W\Widgets\Controls\StyleControls\ColorControl;
use STM_E_W\Widgets\Controls\ContentControls\SelectControl;
use STM_E_W\Widgets\Controls\ContentControls\IconsControl;
use STM_E_W\Widgets\Controls\ContentControls\SwitcherControl;
use STM_E_W\Widgets\Controls\ContentControls\TextControl;
use STM_E_W\Widgets\Controls\StyleControls\SliderControl;
use Motors_E_W\Pro\Widgets\WidgetBase;

class Actions extends WidgetBase {

	use SwitcherControl;
	use IconsControl;
	use TextControl;
	use ColorControl;
	use SliderControl;
	use SelectControl;
	use HeadingControl;

	public function __construct( array $data = array(), array $args = null ) {
		parent::__construct( $data, $args );

		$this->stm_ew_admin_register_ss( $this->get_admin_name(), self::get_name(), MOTORS_ELEMENTOR_WIDGETS_PATH, MOTORS_ELEMENTOR_WIDGETS_URL, MOTORS_ELEMENTOR_WIDGETS_PLUGIN_VERSION );
		$this->stm_ew_enqueue( self::get_name(), MOTORS_ELEMENTOR_WIDGETS_PATH, MOTORS_ELEMENTOR_WIDGETS_URL, MOTORS_ELEMENTOR_WIDGETS_PLUGIN_VERSION, array( 'jquery' ) );
		if ( is_rtl() ) {
			$this->stm_ew_enqueue( self::get_name() . '-rtl', MOTORS_ELEMENTOR_WIDGETS_PATH, MOTORS_ELEMENTOR_WIDGETS_URL, MOTORS_ELEMENTOR_WIDGETS_PLUGIN_VERSION );
		}
	}
	public function get_style_depends(): array {
		$widget_styles   = parent::get_style_depends();
		$widget_styles[] = self::get_name() . '-rtl';

		return $widget_styles;
	}

	public function get_categories() {
		return array( MotorsApp::WIDGET_CATEGORY_SINGLE );
	}

	public function get_name() {
		return MotorsApp::STM_PREFIX . '-single-listing-actions';
	}

	public function get_title() {
		return esc_html__( 'Actions', 'motors-elementor-widgets' );
	}

	public function get_icon() {
		return 'stmew-tab-list';
	}

	protected function register_controls() {
		$this->stm_start_content_controls_section( 'actions_content', esc_html__( 'General', 'motors-elementor-widgets' ) );

		$this->stm_ew_add_select(
			'actions_style',
			array(
				'label'   => esc_html__( 'Style', 'motors-elementor-widgets' ),
				'options' => array(
					'default'    => esc_html__( 'Default', 'motors-elementor-widgets' ),
					'buttons'    => esc_html__( 'Buttons', 'motors-elementor-widgets' ),
					'delimiters' => esc_html__( 'Links with delimiters', 'motors-elementor-widgets' ),
				),
				'default' => 'default',
			),
		);

		$this->stm_ew_add_switcher(
			'show_added_date',
			array(
				'label' => esc_html__( 'Published Date', 'motors-elementor-widgets' ),
			)
		);

		$this->stm_ew_add_switcher(
			'show_print_btn',
			array(
				'label' => esc_html__( 'Print Button', 'motors-elementor-widgets' ),
			)
		);

		$this->stm_ew_add_switcher(
			'show_stock',
			array(
				'label' => esc_html__( 'Stock', 'motors-elementor-widgets' ),
			)
		);

		$this->stm_ew_add_switcher(
			'show_calculator',
			array(
				'label' => esc_html__( 'Loan Calculator', 'motors-elementor-widgets' ),
			)
		);

		if ( defined( 'STM_MOTORS_VIN_DECODERS_PATH' ) ) {
			$this->stm_ew_add_switcher(
				'show_vin',
				array(
					'label' => esc_html__( 'Show VIN', 'motors-elementor-widgets' ),
				)
			);
		}

		$this->stm_ew_add_switcher(
			'show_test_drive',
			array(
				'label' => esc_html__( 'Test Drive Schedule', 'motors-elementor-widgets' ),
			)
		);

		$this->stm_ew_add_switcher(
			'show_compare',
			array(
				'label' => esc_html__( 'Comparison', 'motors-elementor-widgets' ),
			)
		);

		$this->stm_ew_add_switcher(
			'show_share',
			array(
				'label' => esc_html__( 'Sharing', 'motors-elementor-widgets' ),
			)
		);

		$this->stm_ew_add_switcher(
			'show_pdf',
			array(
				'label' => esc_html__( 'PDF Brochure', 'motors-elementor-widgets' ),
			)
		);

		$this->stm_end_control_section();

		$this->stm_start_style_controls_section( 'section_styles', esc_html__( 'General', 'motors-elementor-widgets' ) );

		$this->stm_ew_add_heading(
			'clickable_items_title',
			array(
				'label'     => esc_html__( 'Clickable items', 'motors-elementor-widgets' ),
				'condition' => array(
					'actions_style' => array( 'buttons', 'delimiters' ),
				),
			),
		);

		$this->stm_start_ctrl_tabs( 'tabs_style' );

		$this->stm_start_ctrl_tab(
			'tabs_normal',
			array(
				'label'     => esc_html__( 'Normal', 'motors-elementor-widgets' ),
				'condition' => array(
					'actions_style' => array( 'buttons', 'delimiters' ),
				),
			)
		);

		$this->stm_ew_add_color(
			'clickable_items_color',
			array(
				'label'     => esc_html__( 'Label color', 'motors-elementor-widgets' ),
				'selectors' => array(
					'{{WRAPPER}} .single-car-actions-buttons ul.list-unstyled li > a.actions-item' => 'color: {{VALUE}};',
				),
				'default'   => '#ffffff',
				'condition' => array(
					'actions_style' => 'buttons',
				),
			),
		);

		$this->stm_ew_add_color(
			'clickable_inline_items_color',
			array(
				'label'     => esc_html__( 'Text color', 'motors-elementor-widgets' ),
				'selectors' => array(
					'{{WRAPPER}} .single-car-actions-delimiters ul.list-unstyled li > a.actions-item' => 'color: {{VALUE}};',
				),
				'default'   => '#121e24',
				'condition' => array(
					'actions_style' => 'delimiters',
				),
			),
		);

		$this->stm_ew_add_color(
			'clickable_items_bg_color',
			array(
				'label'     => esc_html__( 'Background color', 'motors-elementor-widgets' ),
				'selectors' => array(
					'{{WRAPPER}} .single-car-actions-buttons ul.list-unstyled li > a.actions-item' => 'background-color: {{VALUE}};',
				),
				'condition' => array(
					'actions_style' => 'buttons',
				),
			),
		);

		$this->stm_end_ctrl_tab();

		$this->stm_start_ctrl_tab(
			'tabs_hover',
			array(
				'label'     => esc_html__( 'Hover', 'motors-elementor-widgets' ),
				'condition' => array(
					'actions_style' => array( 'buttons', 'delimiters' ),
				),
			)
		);

		$this->stm_ew_add_color(
			'clickable_items_color_hover',
			array(
				'label'     => esc_html__( 'Label color', 'motors-elementor-widgets' ),
				'selectors' => array(
					'{{WRAPPER}} .single-car-actions-buttons ul.list-unstyled li > a.actions-item:hover' => 'color: {{VALUE}};',
				),
				'default'   => '#ffffff',
				'condition' => array(
					'actions_style' => 'buttons',
				),
			),
		);

		$this->stm_ew_add_color(
			'clickable_inline_items_color_hover',
			array(
				'label'     => esc_html__( 'Text color', 'motors-elementor-widgets' ),
				'selectors' => array(
					'{{WRAPPER}} .single-car-actions-delimiters ul.list-unstyled li > a.actions-item:hover' => 'color: {{VALUE}};',
				),
				'condition' => array(
					'actions_style' => 'delimiters',
				),
			),
		);

		$this->stm_ew_add_color(
			'clickable_items_bg_color_hover',
			array(
				'label'     => esc_html__( 'Background color', 'motors-elementor-widgets' ),
				'selectors' => array(
					'{{WRAPPER}} .single-car-actions-buttons ul.list-unstyled li > a.actions-item:hover' => 'background-color: {{VALUE}};',
				),
				'condition' => array(
					'actions_style' => 'buttons',
				),
			),
		);

		$this->stm_end_ctrl_tab();

		$this->stm_end_ctrl_tabs();

		$this->stm_ew_add_heading(
			'unclickable_items_title',
			array(
				'label'     => esc_html__( 'Unclickable items', 'motors-elementor-widgets' ),
				'condition' => array(
					'actions_style' => array( 'buttons', 'delimiters' ),
				),
			),
		);

		$this->stm_ew_add_color(
			'unclickable_items_color',
			array(
				'label'     => esc_html__( 'Label color', 'motors-elementor-widgets' ),
				'selectors' => array(
					'{{WRAPPER}} .single-car-actions-buttons ul.list-unstyled li span.added_date_style_button' => 'color: {{VALUE}};',
					'{{WRAPPER}} .single-car-actions-buttons ul.list-unstyled li div.stock-num'                => 'color: {{VALUE}};',
				),
				'default'   => '#121e24',
				'condition' => array(
					'actions_style' => 'buttons',
				),
			),
		);

		$this->stm_ew_add_color(
			'unclickable_inline_items_color',
			array(
				'label'     => esc_html__( 'Text color', 'motors-elementor-widgets' ),
				'selectors' => array(
					'{{WRAPPER}} .single-car-actions-delimiters ul.list-unstyled li span.added_date_style_button' => 'color: {{VALUE}};',
					'{{WRAPPER}} .single-car-actions-delimiters ul.list-unstyled li div.stock-num'                => 'color: {{VALUE}};',
				),
				'default'   => '#ababab',
				'condition' => array(
					'actions_style' => 'delimiters',
				),
			),
		);

		$this->stm_ew_add_color(
			'unclickable_items_bg_color',
			array(
				'label'     => esc_html__( 'Background color', 'motors-elementor-widgets' ),
				'selectors' => array(
					'{{WRAPPER}} .single-car-actions-buttons ul.list-unstyled li span.added_date_style_button' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .single-car-actions-buttons ul.list-unstyled li div.stock-num'                => 'background-color: {{VALUE}};',
				),
				'condition' => array(
					'actions_style' => 'buttons',
				),
			),
		);

		$this->stm_ew_add_color(
			'delimiter_color',
			array(
				'label'     => esc_html__( 'Delimiter color', 'motors-elementor-widgets' ),
				'selectors' => array(
					'{{WRAPPER}} .single-car-actions-delimiters ul.list-unstyled .delimiter:before' => 'background-color: {{VALUE}};',
				),
				'default'   => '#dddddd',
				'condition' => array(
					'actions_style' => 'delimiters',
				),
				'separator' => 'before',
			),
		);

		$this->stm_end_control_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		Helper::stm_ew_load_template( 'pro/widgets/single-listing/actions', MOTORS_ELEMENTOR_WIDGETS_PATH, $settings );
	}

	protected function content_template() {
	}
}
