<?php

namespace Motors_E_W\Widgets\Rental;

use Motors_E_W\MotorsApp;
use STM_E_W\Widgets\Controls\ContentControls\MediaControl;
use STM_E_W\Widgets\Controls\ContentControls\NumberControl;
use STM_E_W\Widgets\WidgetBase;

class RentalOfficesMap extends WidgetBase {

	use MediaControl;
	use NumberControl;

	public function __construct( array $data = array(), array $args = null ) {
		parent::__construct( $data, $args );

		$this->stm_ew_enqueue(
			self::get_name(),
			MOTORS_ELEMENTOR_WIDGETS_PATH,
			MOTORS_ELEMENTOR_WIDGETS_URL,
			MOTORS_ELEMENTOR_WIDGETS_PLUGIN_VERSION,
			array(
				'jquery',
				'stm_gmap',
				'elementor-frontend',
			)
		);
	}

	public function get_categories() {
		return array( MotorsApp::WIDGET_CATEGORY_RENTAL );
	}

	public function get_name() {
		return MotorsApp::STM_PREFIX . '-rental-offices-map';
	}

	public function get_title() {
		return esc_html__( 'Rental Offices Map', 'motors-elementor-widgets' );
	}

	public function get_icon() {
		return 'stmew-google-map eicons-motors';
	}

	protected function register_controls() {
		$this->stm_start_content_controls_section( 'general', __( 'General', 'motors-elementor-widgets' ) );

		$this->stm_ew_add_media(
			'pin',
			array(
				'label'       => __( 'Pin Image', 'motors-elementor-widgets' ),
				'label_block' => true,
				'description' => __( 'Leave empty to use default pin icon from Google, <br> Recommended size not bigger: 70x70', 'motors-elementor-widgets' ),
			)
		);

		$this->stm_ew_add_media(
			'pin_hover',
			array(
				'label'       => __( 'Pin Image On Hover', 'motors-elementor-widgets' ),
				'label_block' => true,
				'description' => __( 'Leave empty to use default pin icon from Google, <br> Recommended size not bigger: 70x70', 'motors-elementor-widgets' ),
			)
		);

		$this->stm_ew_add_number(
			'map_height',
			array(
				'label'       => __( 'Map Height', 'motors-elementor-widgets' ),
				'label_block' => true,
				'description' => __( 'Enter map height in pixels', 'motors-elementor-widgets' ),
				'default'     => 545,
			)
		);

		$this->stm_ew_add_number(
			'map_zoom',
			array(
				'label'       => __( 'Map Zoom', 'motors-elementor-widgets' ),
				'label_block' => true,
				'description' => __( 'Enter map zoom', 'motors-elementor-widgets' ),
				'default'     => 15,
			)
		);
	}

	protected function get_offices(): array {
		$post_types = apply_filters( 'stm_rental_locations', array() );

		return $post_types;
	}

	protected function get_lat_long_address(): array {
		$offices = $this->get_offices();

		$lat_long_address_data = array();

		if ( ! empty( $offices ) ) {
			foreach ( $offices as $office ) {
				$lat                     = $office[1];
				$long                    = $office[2];
				$address                 = wp_strip_all_tags( $office[0] );
				$office_id               = $office[3];
				$lat_long_address_data[] = compact( 'lat', 'long', 'address', 'office_id' );
			}
		}

		return $lat_long_address_data;
	}

	protected function get_pin_icon( $settings ): string {
		if ( ! isset( $settings['pin'] ) || empty( $settings['pin']['url'] ) ) {
			return MOTORS_ELEMENTOR_WIDGETS_URL . '/assets/img/stm-map-marker-green.png';
		}

		return $settings['pin']['url'];
	}

	protected function get_pin_icon_hover( $settings ): string {
		if ( ! isset( $settings['pin_hover'] ) || empty( $settings['pin_hover']['url'] ) ) {
			return MOTORS_ELEMENTOR_WIDGETS_URL . '/assets/img/stm-map-marker-green.png';
		}

		return $settings['pin_hover']['url'];
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$map_data = array(
			'icon' => $this->get_pin_icon( $settings ),
		);

		$map_data     = array_merge( $this->get_lat_long_address(), $map_data );
		$icon_url     = $this->get_pin_icon( $settings );
		$icon_url2    = $this->get_pin_icon_hover( $settings );
		$locationData = $this->get_offices();

		foreach ( $map_data as $key => $datum ) {
			$this->add_render_attribute( 'map_data', $key, $datum );
		}

		foreach ( $map_data as $item ) {
			if ( isset( $item['lat'] ) ) {
				$latitudes[] = $item['lat'];
			}
		}
		foreach ( $map_data as $item ) {
			if ( isset( $item['long'] ) ) {
				$longitudes[] = $item['long'];
			}
		}
		foreach ( $locationData as $item ) {
			if ( isset( $item[0] ) ) {
				$locationHTML[] = $item[0];
			}
		}

		?>
				<div id="stm_map_offices" style="height:<?php echo esc_attr( $settings['map_height'] ); ?>px;" data-lat="<?php echo esc_attr( wp_json_encode( $latitudes ) ); ?>" data-long="<?php echo esc_attr( wp_json_encode( $longitudes ) ); ?>" data-icon="<?php echo esc_url( $icon_url ); ?>" data-icon-hover="<?php echo esc_url( $icon_url2 ); ?>"></div>
				<script>
					var locationHTML = <?php echo wp_json_encode( $locationHTML ); ?>;
					var zoomMap = <?php echo wp_kses_post( $settings['map_zoom'] ); ?>;
				</script>
		<?php
	}

	protected function content_template() {
	}
}
