<?php

namespace Motors_E_W\Widgets\Rental;

use Motors_E_W\MotorsApp;
use STM_E_W\Helpers\Helper;
use STM_E_W\Widgets\WidgetBase;
use STM_E_W\Widgets\Controls\ContentControls\NumberControl;

class RentalProductGrid extends WidgetBase {
	use NumberControl;

	public function __construct( array $data = array(), array $args = null ) {
		parent::__construct( $data, $args );
		$this->stm_ew_admin_register_ss( $this->get_admin_name(), self::get_name(), MOTORS_ELEMENTOR_WIDGETS_PATH, MOTORS_ELEMENTOR_WIDGETS_URL, MOTORS_ELEMENTOR_WIDGETS_PLUGIN_VERSION );
		$this->stm_ew_enqueue( $this->get_name() );
	}

	public function get_categories() {
		return array( MotorsApp::WIDGET_CATEGORY_RENTAL );
	}

	public function get_name() {
		return MotorsApp::STM_PREFIX . '-rental-product-grid';
	}

	public function get_title() {
		return esc_html__( 'Rental Product Grid', 'motors-elementor-widgets' );
	}

	public function get_icon() {
		return 'eicon-posts-grid eicons-motors';
	}

	protected function register_controls() {
		$this->stm_start_content_controls_section( 'general', __( 'General', 'motors-elementor-widgets' ) );

		$this->stm_ew_add_number(
			'product_number',
			array(
				'label'       => __( 'Number of items to show', 'motors-elementor-widgets' ),
				'min'         => 1,
				'step'        => 1,
				'default'     => 6,
				'description' => __( 'Leave empty or input "-1" to show infinite number of product', 'motors-elementor-widgets' ),
			)
		);

	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		Helper::stm_ew_load_template( 'widgets/rental/rental-product-grid', MOTORS_ELEMENTOR_WIDGETS_PATH, $settings );
	}

	protected function content_template() {
	}
}
