<?php
$unique_id      = wp_rand( 1, 99999 );
$mouse_wheel    = ( ! empty( $map_scrollwheel ) && 'yes' === $map_scrollwheel ) ? 'true' : 'false';
$stm_map_height = ( ! empty( $map_height ) ) ? $map_height : 620;
if ( wp_is_mobile() ) {
	$stm_map_height = 500;
}
$pin_url     = ( ! empty( $pin_image ) && is_array( $pin_image ) && ! empty( $pin_image['url'] ) ) ? $pin_image['url'] : get_stylesheet_directory_uri() . '/assets/images/marker-listing-two.png';
$cluster_url = ( ! empty( $cluster_image ) && is_array( $cluster_image ) && ! empty( $cluster_image['url'] ) ) ? $cluster_image['url'] : get_stylesheet_directory_uri() . '/assets/images/cluster-listing-two.png';
do_action( 'stm_google_places_script', 'enqueue' );
?>
<div class="stm-inventory-map-wrap" style="height: <?php echo esc_attr( $stm_map_height ); ?>px;">
	<div class="stm_gmap"
		id="stm_map-<?php echo esc_attr( $unique_id ); ?>"
		data-lat="<?php echo esc_attr( $lat ); ?>"
		data-lng="<?php echo esc_attr( $lng ); ?>"
		data-zoom="<?php echo esc_attr( $map_zoom ); ?>"
		data-address="<?php echo esc_attr( $address ); ?>"
		data-radius="<?php echo esc_attr( $search_radius ); ?>"
		data-scrollwheel="<?php echo esc_attr( $mouse_wheel ); ?>"
		data-pin-url="<?php echo esc_attr( $pin_url ); ?>"
		data-cluster-pin-url="<?php echo esc_attr( $cluster_url ); ?>"></div>
</div>
