<?php
/****
 * @var $attr_boxes_taxonomies
 * @var $attr_boxes_default_icon
 * */

global $listing_id;

$listing_id = ( is_null( $listing_id ) ) ? get_the_ID() : $listing_id;

$post_type = get_query_var( 'post_type' );
if ( function_exists( 'stm_is_multilisting' ) && stm_is_multilisting() && apply_filters( 'stm_listings_post_type', 'listings' ) !== $post_type && 'listing_template' !== $post_type ) {
	$attr_boxes_taxonomies = ( isset( ${'attr_boxes_taxonomies_' . $post_type} ) && ! empty( ${'attr_boxes_taxonomies_' . $post_type} ) ) ? ${'attr_boxes_taxonomies_' . $post_type} : array();
} else {
	$attr_boxes_taxonomies = ( empty( $attr_boxes_taxonomies ) ) ? array() : $attr_boxes_taxonomies;
}

$attributes = apply_filters( 'stm_get_all_listing_attributes', array(), 'all' );
?>
<div class="single-listing-attribute-boxes">
	<?php
	foreach ( $attr_boxes_taxonomies as $tax ) :
		$arr_key = array_search( $tax, array_column( $attributes, 'slug' ), true );

		if ( empty( $attributes[ $arr_key ]['slug'] ) ) {
			continue;
		}

		// icon.
		if ( ! empty( $attributes[ $arr_key ]['font'] ) ) {
			$icon = $attributes[ $arr_key ]['font'];
		} elseif ( function_exists( 'stm_is_multilisting' ) && stm_is_multilisting() && 'listings' !== $post_type && 'listing_template' !== $post_type ) {
			$icon_arr = ${'attr_boxes_default_icon_' . $post_type};
			$icon     = ( is_array( $icon_arr ) && isset( $icon_arr['value'] ) ) ? $icon_arr['value'] : '';
		} else {
			$icon_arr = $attr_boxes_default_icon;
			$icon     = ( is_array( $icon_arr ) && isset( $icon_arr['value'] ) ) ? $icon_arr['value'] : '';
		}

		// attribute value.
		if ( false !== strpos( $attributes[ $arr_key ]['slug'], 'price' ) ) {
			$custom_price_value = get_post_meta( $listing_id, $attributes[ $arr_key ]['slug'], true );
			$common_price_value = get_post_meta( $listing_id, 'price', true );

			if ( apply_filters( 'stm_is_listing_price_field', $attributes[ $arr_key ]['slug'] ) || ( empty( $custom_price_value ) && ! empty( $common_price_value ) ) ) {
				$meta_value = $common_price_value;
			} else {
				$meta_value = $custom_price_value;
			}
		} else {
			$meta_value = get_post_meta( $listing_id, $attributes[ $arr_key ]['slug'], true );
		}

		$value = '';
		if ( ! empty( $meta_value ) && 'none' !== $meta_value ) {
			if ( ! empty( $attributes[ $arr_key ]['numeric'] ) && $attributes[ $arr_key ]['numeric'] ) {
				$value = esc_attr( ucfirst( $meta_value ) );
			} else {
				$data_meta_array = explode( ',', $meta_value );
				$datas           = array();

				if ( ! empty( $data_meta_array ) ) {
					foreach ( $data_meta_array as $data_meta_single ) {
						$data_meta = get_term_by( 'slug', $data_meta_single, $attributes[ $arr_key ]['slug'] );
						if ( ! empty( $data_meta->name ) ) {
							$datas[] = esc_attr( $data_meta->name );
						}
					}
				}

				$value = implode( ', ', $datas );
			}
		}

		?>
		<div class="item">
			<span class="icon">
				<i class="<?php echo esc_attr( $icon ); ?>"></i>
			</span>
			<div class="label-text"><?php echo ( ! empty( $attributes[ $arr_key ]['single_name'] ) ) ? esc_attr( $attributes[ $arr_key ]['single_name'] ) : ''; ?></div>
			<div class="value-text"><?php echo esc_html( $value ); ?></div>
		</div>
	<?php endforeach; ?>
</div>
