<?php
/**
 * Listing category settings
 */

add_filter(
	'demo_layout_settings',
	function ( $options ) {
		if ( isset( $_GET['post_type'] ) && apply_filters( 'stm_listings_post_type', 'listings' ) !== $_GET['post_type'] ) {
			foreach ( $options as $slug => $arr ) {
				if ( ! empty( $arr['label'] ) && strpos( $arr['label'], 'car' ) !== false ) {
					$options[ $slug ]['label'] = esc_html( str_replace( 'car', 'listing', $arr['label'] ) );
				} elseif ( ! empty( $arr['description'] ) && strpos( $arr['description'], 'car' ) !== false ) {
					$options[ $slug ]['description'] = esc_html( str_replace( 'car', 'listing', $arr['description'] ) );
				}
			}
		}

		return $options;
	}
);
