<?php
/**
 * Order details
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/order/order-details.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woo.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.5.0
 *
 * @var bool $show_downloads Controls whether the downloads table should be rendered.
 */

defined( 'ABSPATH' ) || exit;

$order = wc_get_order( $order_id ); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited

if ( ! $order ) {
	return;
}

if ( apply_filters( 'stm_is_rental', false ) ) {
	get_template_part( 'partials/rental/common/order', 'details' );
	return false;
}

$order_items           = $order->get_items( apply_filters( 'woocommerce_purchase_order_item_types', 'line_item' ) );
$show_purchase_note    = $order->has_status( apply_filters( 'woocommerce_purchase_note_order_statuses', array( 'completed', 'processing' ) ) );
$show_customer_details = is_user_logged_in() && $order->get_user_id() === get_current_user_id();
$downloads             = $order->get_downloadable_items();

if ( $show_downloads ) {
	wc_get_template(
		'order/order-downloads.php',
		array(
			'downloads'  => $downloads,
			'show_title' => true,
		)
	);
}

$rowName = __( 'Product', 'motors' );

if ( apply_filters( 'stm_is_dealer_two', false ) ) {
	$orderData = $order_items[ key( $order_items ) ];

	$listingId = get_post_meta( $orderData->get_order_id(), 'order_sell_online_car_id', true );
	if ( $listingId ) {
		$rowName = __( 'Vehicle', 'motors' );
	}
}

?>
<div class="colored-separator text-left">
	<div class="first-long"></div>
	<div class="last-short"></div>
</div>
<h4><?php esc_html_e( 'Order Details', 'motors' ); ?></h4>
<table class="shop_table order_details">
	<thead>
		<tr>
			<th class="product-name"><?php echo esc_html( $rowName ); ?></th>
			<th class="product-total"><?php esc_html_e( 'Total', 'motors' ); ?></th>
		</tr>
	</thead>
	<tbody>
		<?php
		foreach ( $order_items as $item_id => $item ) {
				$product = apply_filters( 'woocommerce_order_item_product', $item->get_product(), $item );

				wc_get_template(
					'order/order-details-item.php',
					array(
						'order'              => $order,
						'item_id'            => $item_id,
						'item'               => $item,
						'show_purchase_note' => $show_purchase_note,
						'purchase_note'      => $product ? $product->get_purchase_note() : '',
						'product'            => $product,
					)
				);
		}
		?>
		<?php do_action( 'woocommerce_order_items_table', $order ); ?>
	</tbody>
	<tfoot>
		<?php
		foreach ( $order->get_order_item_totals() as $key => $total ) {
			?>
				<tr>
					<th scope="row"><?php echo esc_html( $total['label'] ); ?></th>
					<td><?php echo ( 'payment_method' === $key ) ? esc_html( $total['value'] ) : wp_kses_post( $total['value'] ); //phpcs:ignore?></td>
				</tr>
				<?php
		}
		?>
		<?php if ( $order->get_customer_note() ) : ?>
			<tr>
				<th><?php esc_html_e( 'Note:', 'motors' ); ?></th>
				<td><?php echo esc_html( wptexturize( $order->get_customer_note() ) ); ?></td>
			</tr>
		<?php endif; ?>
	</tfoot>
</table>

<?php do_action( 'woocommerce_order_details_after_order_table', $order ); ?>

<?php
if ( $show_customer_details ) {
	wc_get_template( 'order/order-details-customer.php', array( 'order' => $order ) );
}
