class MotorsRentalOfficesMap extends elementorModules.frontend.handlers.Base {
	getDefaultSettings() {
		return {
			selectors: {
				stm_map_offices: '#stm_map_offices',
			},
		};
	}

	getDefaultElements() {
		const selectors = this.getSettings('selectors');
		return {
			$stm_map_offices: this.$element.find(selectors.stm_map_offices),
		};
	}

	mapInit() {
		const mapElement = this.elements.$stm_map_offices[0];
		const latitudes = JSON.parse(mapElement.getAttribute('data-lat'));
		const longitudes = JSON.parse(mapElement.getAttribute('data-long'));
		const infoWindow = new google.maps.InfoWindow();
		const mapStyles = [
			{
				"featureType": "administrative",
				"elementType": "labels.text.fill",
				"stylers": [
					{
						"color": "#444444"
					}
				]
			},
			{
				"featureType": "landscape",
				"elementType": "all",
				"stylers": [
					{
						"color": "#f2f2f2"
					}
				]
			},
			{
				"featureType": "poi",
				"elementType": "all",
				"stylers": [
					{
						"visibility": "off"
					}
				]
			},
			{
				"featureType": "road",
				"elementType": "all",
				"stylers": [
					{
						"saturation": -100
					},
					{
						"lightness": 45
					}
				]
			},
			{
				"featureType": "road.highway",
				"elementType": "all",
				"stylers": [
					{
						"visibility": "simplified"
					}
				]
			},
			{
				"featureType": "road.arterial",
				"elementType": "labels.icon",
				"stylers": [
					{
						"visibility": "off"
					}
				]
			},
			{
				"featureType": "transit",
				"elementType": "all",
				"stylers": [
					{
						"visibility": "off"
					}
				]
			},
			{
				"featureType": "water",
				"elementType": "all",
				"stylers": [
					{
						"color": "#6c98e1"
					},
					{
						"visibility": "on"
					}
				]
			}
		];

		const bounds = new google.maps.LatLngBounds();
		const map = new google.maps.Map(mapElement, {
			zoom: zoomMap,
			fullscreenControl: true,
			scrollwheel: false,
			styles: mapStyles,
		});

		for (let i = 0; i < latitudes.length; i++) {
			const locationLatLng = new google.maps.LatLng(latitudes[i], longitudes[i]);
			const iconHover = mapElement.getAttribute('data-icon-hover');
			const icon = mapElement.getAttribute('data-icon');

			const marker = new google.maps.Marker({
				position: locationLatLng,
				icon: mapElement.getAttribute('data-icon'),
				map: map
			});
			google.maps.event.addListener(marker, 'click', (function(marker, i) {
				return function() {
					infoWindow.setContent(locationHTML[i]);
					infoWindow.open(map, marker);
				};
			})(marker, i));

			google.maps.event.addListener(marker, 'mouseover', function () {
				this.setIcon(iconHover);
			});

			google.maps.event.addListener(marker, 'mouseout', function () {
				this.setIcon(icon);
			});

			bounds.extend(locationLatLng);
		}

		map.setCenter(bounds.getCenter());
		map.fitBounds(bounds);

		let mapZoom = zoomMap;
		const boundsListener = google.maps.event.addListener(map, 'bounds_changed', (event) => {
			clearTimeout(this.timeOut);
			this.timeOut = setTimeout(() => {
				map.setZoom(mapZoom);
			}, 400);
			google.maps.event.removeListener(boundsListener);
		});

		return map;
	}

	mapSetup() {
		const mapElement = this.elements.$stm_map_offices[0];
		const latitudes = JSON.parse(mapElement.getAttribute('data-lat'));
		const longitudes = JSON.parse(mapElement.getAttribute('data-long'));
		const center = new google.maps.LatLng(latitudes[0], longitudes[0]);

		let map = this.mapInit();
		jQuery(window).on('resize', function () {
			map.setCenter(center);
		});
	}

	onInit() {
		super.onInit()

		if ( typeof google.maps.LatLng !== 'undefined' ) {
			this.mapSetup();
		} else {
			document.body.addEventListener('stm_gmap_api_loaded', () => { this.mapSetup() }, false);
		}
	}
}

jQuery(window).on('elementor/frontend/init', () => {
	const addHandler = ($element) => {
		elementorFrontend.elementsHandler.addHandler(MotorsRentalOfficesMap, {
			$element,
		});
	};

	elementorFrontend.hooks.addAction('frontend/element_ready/motors-rental-offices-map.default', addHandler);
});
