<?php

namespace Motors_E_W\Widgets\Rental;

use Elementor\Plugin;
use Motors_E_W\MotorsApp;
use STM_E_W\Widgets\WidgetBase;
use STM_E_W\Helpers\Helper;

class RentalCheckoutForm extends WidgetBase {

	public function __construct( array $data = array(), array $args = null ) {
		parent::__construct( $data, $args );
		$this->stm_ew_admin_register_ss( $this->get_admin_name(), self::get_name(), MOTORS_ELEMENTOR_WIDGETS_PATH, MOTORS_ELEMENTOR_WIDGETS_URL, MOTORS_ELEMENTOR_WIDGETS_PLUGIN_VERSION );
		$this->stm_ew_enqueue( $this->get_name() );
	}

	public function get_categories() {
		return array( MotorsApp::WIDGET_CATEGORY_RENTAL );
	}

	public function get_name() {
		return MotorsApp::STM_PREFIX . '-rental-checkout-form';
	}

	public function get_title() {
		return esc_html__( 'Rental Checkout Form', 'motors-elementor-widgets' );
	}

	public function get_icon() {
		return 'eicon-checkout eicons-motors';
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		Helper::stm_ew_load_template( 'widgets/rental/rental-checkout-form', MOTORS_ELEMENTOR_WIDGETS_PATH, $settings );
	}

	protected function content_template() {

	}
}
