<?php
/****
 * @var $slides
 * @var $loop
 * @var $autoplay
 * @var $transition_speed
 * @var $delay
 * @var $pause_on_mouseover
 * @var $navigation
 * @var $stretch
 * @var $include_video
 * @var $show_pdf
 * @var $show_print
 * @var $show_compare
 * @var $show_test_drive
 * @var $show_share
 * */

global $listing_id;

$listing_id = ( is_null( $listing_id ) ) ? get_the_ID() : $listing_id;
$uniq_id    = uniqid();

// Getting gallery list.
$gallery          = get_post_meta( $listing_id, 'gallery', true );
$video_preview    = get_post_meta( $listing_id, 'video_preview', true );
$gallery_video    = get_post_meta( $listing_id, 'gallery_video', true );
$sold             = get_post_meta( $listing_id, 'car_mark_as_sold', true );
$sold_badge_color = apply_filters( 'motors_vl_get_nuxy_mod', '', 'sold_badge_bg_color' );
$special_car      = get_post_meta( $listing_id, 'special_car', true );
$badge_text       = get_post_meta( $listing_id, 'badge_text', true );
$badge_bg_color   = get_post_meta( $listing_id, 'badge_bg_color', true );
$car_brochure     = get_post_meta( $listing_id, 'car_brochure', true );
$placeholder_path = 'plchldr350.png';
if ( empty( $badge_text ) ) {
	$badge_text = esc_html__( 'Featured Listing', 'motors-elementor-widgets' );
}

$badge_style = '';
if ( ! empty( $badge_bg_color ) ) {
	$badge_style = 'style=color:' . $badge_bg_color . ';';
}

$gallery_to_show = array();

if ( has_post_thumbnail( $listing_id ) ) {
	$src = wp_get_attachment_image_src( get_post_thumbnail_id( $listing_id ), 'stm-img-398-x-2' );

	if ( is_array( $src ) ) {
		$full_src = wp_get_attachment_image_src( get_post_thumbnail_id( $listing_id ), 'full' );
		$new_item = array(
			'image' => $src,
			'id'    => get_post_thumbnail_id( $listing_id ),
		);
		if ( is_array( $full_src ) ) {
			$new_item['link'] = $full_src[0];
		}
		$gallery_to_show[] = $new_item;
	}
}

if ( $include_video && ! empty( $video_preview ) && ! empty( $gallery_video ) ) {
	$src = wp_get_attachment_image_src( $video_preview, 'stm-img-398-x-2' );
	if ( is_array( $src ) ) {
		$gallery_to_show[] = array(
			'image'     => $src,
			'video_src' => $gallery_video,
			'id'        => $video_preview,
		);
	}
} elseif ( ! empty( $gallery_video ) && empty( $video_preview ) ) {
	$src               = array();
	$src[]             = get_stylesheet_directory_uri() . '/assets/images/' . $placeholder_path;
	$gallery_to_show[] = array(
		'image'     => $src,
		'video_src' => $gallery_video,
		'id'        => 0,
	);
}

if ( ! empty( $gallery ) ) {

	foreach ( $gallery as $gallery_image ) {

		if ( get_post_thumbnail_id( $listing_id ) !== $gallery_image ) {

			$src = wp_get_attachment_image_src( $gallery_image, 'stm-img-398-x-2' );
			if ( is_array( $src ) ) {
				$full_src = wp_get_attachment_image_src( $gallery_image, 'full' );
				$new_item = array(
					'image' => $src,
					'id'    => $gallery_image,
				);
				if ( is_array( $full_src ) ) {
					$new_item['link'] = $full_src[0];
				}
				$gallery_to_show[] = $new_item;
			}
		}
	}
}

$slider_options = false;
$max_per_view   = 4;
$use_slider     = false;

if ( count( $gallery_to_show ) < $max_per_view ) {
	$items_per_view = count( $gallery_to_show );
} else {
	$items_per_view = $max_per_view;

	if ( ! wp_is_mobile() ) {
		$use_slider     = true;
		$slider_options = compact(
			'loop',
			'autoplay',
			'transition_speed',
			'delay',
			'pause_on_mouseover',
			'navigation',
		);

		$slider_options['slides_per_view'] = $items_per_view;
	}
}

if ( empty( $gallery_to_show ) ) {
	$items_per_view = 1;
}

?>

<div class="motors-elementor-single-listing-gallery-carousel">

	<div class="stm-gallery-meta-top">

		<div class="stm-gallery-actions-box">
			<?php if ( 'yes' === $show_pdf && ! empty( $car_brochure ) ) : ?>
				<div class="stm-gallery-action-unit">
					<a href="<?php echo esc_url( wp_get_attachment_url( $car_brochure ) ); ?>" class="stm-brochure" title="<?php esc_html_e( 'Download brochure', 'motors-elementor-widgets' ); ?>" download>
						<i class="stm-icon-brochure"></i>
					</a>
				</div>
			<?php endif; ?>
			<?php if ( 'yes' === $show_print ) : ?>
				<div class="stm-gallery-action-unit stm-listing-print-action">
					<a href="javascript:window.print()" class="car-action-unit stm-car-print">
						<i class="fas fa-print"></i>
					</a>
				</div>
			<?php endif; ?>
			<?php if ( apply_filters( 'is_listing', array() ) && ! empty( $show_featured ) && 'yes' === $show_featured ) : ?>
				<div class="stm-gallery-action-unit stm-listing-favorite-action" data-id="<?php echo esc_attr( $listing_id ); ?>">
					<i class="stm-service-icon-staricon"></i>
				</div>
			<?php endif; ?>
			<?php if ( 'yes' === $show_compare ) : ?>
				<div class="stm-gallery-action-unit compare" data-id="<?php echo esc_attr( $listing_id ); ?>" data-title="<?php echo wp_kses_post( apply_filters( 'stm_generate_title_from_slugs', get_the_title( $listing_id ), $listing_id ) ); ?>" data-post-type="<?php echo esc_attr( get_post_type( $listing_id ) ); ?>" data-placement="bottom">
					<i class="stm-service-icon-compare-new"></i>
				</div>
			<?php endif; ?>
			<?php if ( 'yes' === $show_test_drive ) : ?>
				<div class="stm-gallery-action-unit stm-schedule" data-toggle="modal" data-target="#test-drive" onclick="stm_test_drive_car_title(<?php echo esc_js( $listing_id ); ?>, '<?php echo esc_js( get_the_title( $listing_id ) ); ?>')">
					<i class="stm-icon-steering_wheel"></i>
				</div>
			<?php endif; ?>
			<?php if ( 'yes' === $show_share ) : ?>
				<div class="stm-gallery-action-unit">
					<i class="stm-icon-share"></i>
					<?php if ( function_exists( 'ADDTOANY_SHARE_SAVE_KIT' ) && ! get_post_meta( $listing_id, 'sharing_disabled', true ) ) : ?>
						<div class="stm-a2a-popup">
							<?php echo apply_filters( 'stm_add_to_any_shortcode', $listing_id ); //phpcs:ignore ?>
						</div>
					<?php endif; ?>
				</div>
			<?php endif; ?>
		</div>

		<div class="stm-gallery-listing-info">

			<?php if ( empty( $sold ) && ! empty( $special_car ) && 'on' === $special_car ) : ?>

				<div class="stm-gallery-listing-info-item special-label-inline" <?php echo esc_attr( $badge_style ); ?>>
					<?php if ( ! empty( $featured_icon ) ) : ?>
						<i class="<?php echo esc_attr( $featured_icon['value'] ); ?>"></i>
					<?php endif; ?>
					<span class="label"><?php echo esc_html( apply_filters( 'stm_dynamic_string_translation', $badge_text, 'Special Badge Text' ) ); ?></span>
				</div>

			<?php elseif ( true === apply_filters( 'stm_sold_status_enabled', false ) && ! empty( $sold ) && ! empty( $show_sold_label ) ) : ?>

				<?php $badge_style = 'style=background-color:' . $sold_badge_color . ';color:#fff;font-size:20px;padding:4px;min-width:100px;justify-content:center;'; ?>
				<div class="stm-gallery-listing-info-item special-label-inline" <?php echo esc_attr( $badge_style ); ?>>
					<?php esc_html_e( 'Sold', 'motors-elementor-widgets' ); ?>
				</div>

			<?php endif; ?>

			<!--New badge with videos-->
			<?php $car_media = apply_filters( 'stm_get_car_medias', array(), $listing_id ); ?>
			<?php if ( ! empty( $car_media['car_videos_count'] ) && $car_media['car_videos_count'] > 0 ) : ?>

				<div class="stm-gallery-listing-info-item stm-car-videos stm-car-videos-<?php echo esc_attr( $listing_id ); ?>">
					<i class="fas fa-film"></i>
					<span><?php echo esc_html( $car_media['car_videos_count'] ); ?><?php esc_html_e( 'Video', 'motors-elementor-widgets' ); ?></span>
				</div>

				<?php // @codingStandardsIgnoreStart ?>
				<script>
					jQuery(document).ready(function () {
						jQuery(".stm-car-videos-<?php echo esc_js( $listing_id ); ?>").on('click', function () {
							jQuery(this).lightGallery({
								dynamic: true,
								dynamicEl: [
									<?php foreach ( $car_media['car_videos'] as $car_video ) : ?>
									{
										src: "<?php echo esc_url( $car_video ); ?>"
									},
									<?php endforeach; ?>
								],
								download: false,
								mode: 'lg-fade',
							})
						}); //click
					}); //ready
				</script>
				<?php // @codingStandardsIgnoreEnd ?>
			<?php endif; ?>

		</div>

	</div>

	<?php $wrapper_class = ( 'yes' === $stretch && ( $items_per_view > 2 || wp_is_mobile() ) ) ? 'stretch' : ''; ?>

	<div class="listing-gallery-carousel-wrapper <?php echo esc_attr( $wrapper_class ); ?>">

		<div class="listing-gallery-carousel listing-gallery-carousel-<?php echo esc_attr( $uniq_id ); ?> items-per-view-<?php echo esc_attr( $items_per_view ); ?> swiper-container" data-options="<?php echo esc_attr( wp_json_encode( $slider_options ) ); ?>" data-widget-id="<?php echo esc_attr( $uniq_id ); ?>">
			<div class="swiper-wrapper">

				<?php
				if ( ! empty( $gallery_to_show ) ) {

					foreach ( $gallery_to_show as $gallery_item ) {
						$video_item = ( ! empty( $gallery_item['video_src'] ) ) ? ' video-preview' : '';
						?>
						<div class="item swiper-slide <?php echo esc_attr( $video_item ); ?>" data-id="big-image-<?php echo esc_attr( $gallery_item['id'] ); ?>">
							<a
							<?php if ( ! empty( $gallery_item['link'] ) ) : ?>
								href="<?php echo esc_url( $gallery_item['link'] ); ?>"
								class="stm_fancybox"
								rel="stm-car-gallery-carousel"
							<?php endif; ?>
							<?php if ( ! empty( $gallery_item['video_src'] ) ) : ?>
								data-src="<?php echo esc_url( $gallery_item['video_src'] ); ?>"
								class="fancy-iframe"
								data-iframe="true"
							<?php endif; ?>
							>
								<img
									<?php if ( $items_per_view < 3 && ! empty( $gallery_item['link'] ) ) : ?>
										src="<?php echo esc_attr( $gallery_item['link'] ); ?>"
									<?php else : ?>
										src="<?php echo esc_attr( $gallery_item['image'][0] ); ?>"
									<?php endif; ?>
									width="<?php echo esc_attr( $gallery_item['image'][1] ); ?>"
									height="<?php echo esc_attr( $gallery_item['image'][2] ); ?>"
									alt="<?php the_title(); ?>"
								/>
							</a>
						</div>
						<?php
					}
				} else {
					?>
					<div class="item swiper-slide placeholder">
						<img
							src="<?php echo esc_url( get_stylesheet_directory_uri() . '/assets/images/' . $placeholder_path ); ?>"
							class="img-responsive"
							alt="<?php the_title(); ?>"/>
					</div>
					<?php
				}
				?>
			</div>
			<?php if ( $navigation && $use_slider ) : ?>
				<div class="listing-gallery-carousel-nav">
					<div class="listing-gallery-carousel-nav-prev"></div>
					<div class="listing-gallery-carousel-nav-next"></div>
				</div>
			<?php endif; ?>
		</div>

	</div>

</div>
